/*
 * Decompiled with CFR 0.152.
 */
package OreSpawn.entities;

import OreSpawn.OreSpawnMain;
import OreSpawn.entities.BoogieBat;
import OreSpawn.entities.PetaBat;
import dangerzone.Player;
import dangerzone.Utils;
import dangerzone.World;
import dangerzone.entities.Entity;
import dangerzone.items.Items;

public class ExaBat
extends PetaBat {
    public int numsegs = 20;
    public double[] lposx = new double[this.numsegs];
    public double[] lposy = new double[this.numsegs];
    public double[] lposz = new double[this.numsegs];
    public double[] rotpitch = new double[this.numsegs];
    public double[] rotroll = new double[this.numsegs];
    public double[] rotyaw = new double[this.numsegs];
    public long lasttime = 0L;

    public ExaBat(World w) {
        super(w);
        this.uniquename = "OreSpawn:Exa Bat";
        this.always_draw = true;
        this.setMaxHealth(175.0f);
        this.setHealth(175.0f);
        this.setDefense(7.5f);
        this.setAttackDamage(35.0f);
        if (w != null) {
            this.myspeed = 0.35f + w.rand.nextFloat() * 0.1f;
        }
        this.takesFallDamage = false;
        this.setExperience(935);
        this.temperament = 1;
        this.searchDistance = 85.0f;
        this.attackRange = 5.5f;
    }

    public void init() {
        super.init();
        double mx = (float)Math.sin(Math.toRadians(this.rotation_yaw)) * 0.75f;
        double mz = (float)Math.cos(Math.toRadians(this.rotation_yaw)) * 0.75f;
        mx /= 2.0;
        mz /= 2.0;
        int i = 0;
        while (i < this.numsegs) {
            this.lposx[i] = this.posx - mx * (double)i * 1.5;
            this.lposy[i] = this.posy + (double)((float)Math.sin(Math.toRadians(i * 10 + 180)) * 4.0f);
            this.lposz[i] = this.posz - mz * (double)i * 1.5;
            this.rotpitch[i] = 0.0;
            this.rotroll[i] = 0.0;
            this.rotyaw[i] = this.rotation_yaw;
            ++i;
        }
    }

    public void player_morph_update(float deltaT, Player pl) {
        long curtime = System.currentTimeMillis();
        double distdiff = Math.sqrt((this.posx - this.lposx[0]) * (this.posx - this.lposx[0]) + (this.posy - this.lposy[0]) * (this.posy - this.lposy[0]) + (this.posz - this.lposz[0]) * (this.posz - this.lposz[0]));
        double maxdiff = 2.0;
        long maxtime = 75L;
        if (this.isBaby()) {
            maxdiff = 0.25;
            maxtime = 25L;
        }
        this.posx = pl.posx;
        this.posy = pl.posy;
        this.posz = pl.posz;
        float derp = (float)Math.toDegrees(Math.atan2(-pl.motiony, Math.sqrt(pl.motionx * pl.motionx + pl.motionz * pl.motionz)));
        if (curtime - this.lasttime > maxtime || distdiff > maxdiff) {
            this.lasttime = curtime;
            int i = this.numsegs - 1;
            while (i > 0) {
                this.lposx[i] = this.lposx[i - 1];
                this.lposy[i] = this.lposy[i - 1];
                this.lposz[i] = this.lposz[i - 1];
                this.rotpitch[i] = this.rotpitch[i - 1];
                this.rotroll[i] = this.rotroll[i - 1];
                this.rotyaw[i] = this.rotyaw[i - 1];
                --i;
            }
            this.lposx[0] = this.posx;
            this.lposy[0] = this.posy;
            this.lposz[0] = this.posz;
            this.rotpitch[0] = derp;
            this.rotroll[0] = this.display_rotation_roll;
            this.rotyaw[0] = this.display_rotation_yaw;
        }
    }

    @Override
    public void update(float deltaT) {
        BoogieBat sc;
        long curtime = System.currentTimeMillis();
        double distdiff = Math.sqrt((this.posx - this.lposx[0]) * (this.posx - this.lposx[0]) + (this.posy - this.lposy[0]) * (this.posy - this.lposy[0]) + (this.posz - this.lposz[0]) * (this.posz - this.lposz[0]));
        double maxdiff = 2.0;
        long maxtime = 75L;
        if (this.isBaby()) {
            maxdiff = 0.25;
            maxtime = 25L;
        }
        if (curtime - this.lasttime > maxtime || distdiff > maxdiff) {
            this.lasttime = curtime;
            int i = this.numsegs - 1;
            while (i > 0) {
                this.lposx[i] = this.lposx[i - 1];
                this.lposy[i] = this.lposy[i - 1];
                this.lposz[i] = this.lposz[i - 1];
                this.rotpitch[i] = this.rotpitch[i - 1];
                this.rotroll[i] = this.rotroll[i - 1];
                this.rotyaw[i] = this.rotyaw[i - 1];
                --i;
            }
            this.lposx[0] = this.posx;
            this.lposy[0] = this.posy;
            this.lposz[0] = this.posz;
            this.rotpitch[0] = this.display_rotation_pitch * 2.0f;
            this.rotroll[0] = this.display_rotation_roll;
            this.rotyaw[0] = this.display_rotation_yaw;
        }
        int chance = 500;
        if (this.getAttacking()) {
            chance = 30;
        }
        if (this.world.rand.nextInt(chance) == 1 && (sc = (BoogieBat)this.world.createEntityByName("OreSpawn:Boogie Bat", this.dimension, this.posx, this.posy + 0.5, this.posz)) != null) {
            sc.init();
            sc.setIID(1);
            this.world.spawnEntityInWorld((Entity)sc);
        }
        super.update(deltaT);
    }

    @Override
    public void doDeathDrops() {
        Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.trophyexabat.itemID, (float)1.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        int i = 0;
        while (i < 13) {
            Utils.doDropRand((World)this.world, (int)0, (int)Items.deadbug.itemID, (float)4.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            ++i;
        }
        i = 0;
        while (i < 15) {
            Utils.doDropRand((World)this.world, (int)0, (int)Items.furball.itemID, (float)4.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            ++i;
        }
        i = 0;
        while (i < 9) {
            Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.pig_guts.itemID, (float)5.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            ++i;
        }
        i = 0;
        while (i < 9) {
            Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.pig_nose.itemID, (float)5.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            ++i;
        }
        i = 0;
        while (i < 9) {
            Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.pig_toes.itemID, (float)5.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            ++i;
        }
        i = 0;
        while (i < 9) {
            Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.pig_tail.itemID, (float)5.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            ++i;
        }
        i = 0;
        while (i < 9) {
            Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.pig_ear.itemID, (float)5.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            ++i;
        }
        Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.experiencetree_seed.itemID, (float)1.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.experiencetree_seed.itemID, (float)1.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.experiencetree_seed.itemID, (float)1.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        i = 0;
        while (i < 15) {
            Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.minersdream.itemID, (float)4.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            ++i;
        }
        Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.nightmaresword.itemID, (float)2.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
    }
}

